

import expertSystemShell.*;
import unificationSolver.Constant;
import unificationSolver.Variable;
import unificationSolver.SubstitutionSet;

public class ESTester {
		public static void main(String[] args) {
			
			try {

				Constant parent = new Constant("parent"),
						bill = new Constant("Bill"),
						audrey = new Constant("Audrey"),
						maria = new Constant("Maria"),
						tony = new Constant("Tony"),
						charles = new Constant("Charles"),
						ancestor = new Constant("ancestor");
	
				Variable X = new Variable("X"), Y = new Variable("Y"), Z = new Variable("Z");
				
				ESFrontEnd frontEnd = new DefaultFrontEnd();
				
				ESRuleSet rules = new ESRuleSet(frontEnd,
							//new ESAsk(new ESSimpleSentence(parent, bill, audrey)),
							//new ESAsk(new ESSimpleSentence(parent, maria, bill)),
							new ESRule(new ESSimpleSentence(parent, bill, audrey), 1.0),
							new ESRule(new ESSimpleSentence(parent, maria, bill), 1.0),
							new ESRule(new ESSimpleSentence(parent, tony, maria), 1.0),
							new ESRule(new ESSimpleSentence(parent, charles, tony), 1.0),
							new ESRule(new ESSimpleSentence(ancestor, X, Y), new ESSimpleSentence(parent, X, Y), 1.0),
							new ESRule(new ESSimpleSentence(ancestor, X, Y), 
									new ESAnd(new ESSimpleSentence(parent, X, Z), new ESSimpleSentence(ancestor, Z, Y)), 
									0.5)
						);
				
				solve (new ESSimpleSentence(ancestor, charles, Y), rules);
				solve (new ESSimpleSentence(ancestor, X, audrey), rules);
				solve (new ESSimpleSentence(ancestor, X, Y), rules);
			} catch (Exception e){}
			
	}
	
		
	private static void solve(ESSimpleSentence goal, ESRuleSet rules){
		
		try {
			ESSimpleSentenceSolutionNode root = (ESSimpleSentenceSolutionNode)goal.getSolver(rules, new SubstitutionSet());

			SubstitutionSet solution;
			
			System.out.println("Goal = " + goal);
			System.out.println("Solutions:");
			while((solution = root.nextSolution()) != null){
				System.out.println("     " + goal.replaceVariables(solution) + ", certainty = " + root.getCertainty());
			}
			System.out.println("      nodes visited = " + root.nodesCreated);
		} catch (Exception e) {}
	}
}
